/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.control;

import java.awt.Component;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.gui.dialogs.FindReplaceDialog;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FilenameUtils;

public class GrammarCommandInternalFrameListener
implements InternalFrameListener {
    private JMenuBar menuBar;
    private GrammarEditorShellController controller;

    public GrammarCommandInternalFrameListener(GrammarEditorShellController ctrl) {
        this.controller = ctrl;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.menuBar = Launcher.getMenuBar();
        this.controller.editor.grammarMenu.setVisible(true);
        this.controller.editor.GrammarEditMenu.setVisible(true);
        this.menuBar.add(this.controller.editor.grammarMenu);
        this.menuBar.add((Component)this.controller.editor.GrammarEditMenu, 2);
        Launcher.mnEdit.setVisible(false);
        boolean b = false;
        int n = Launcher.mnWindows.getItemCount();
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + "." + FilenameUtils.getExtension(this.controller.getFullName());
        for (int i = 0; i < n; ++i) {
            if (Launcher.mnWindows.getItem(i) == null) continue;
            String aux = Launcher.mnWindows.getItem(i).getText();
            if (aux.equals(basename)) {
                Launcher.mnWindows.getItem(i).setSelected(true);
                b = true;
                continue;
            }
            Launcher.mnWindows.getItem(i).setSelected(false);
        }
        if (!b) {
            JCheckBoxMenuItem checkmenu = new JCheckBoxMenuItem(basename);
            checkmenu.setSelected(true);
            Launcher.mnWindows.add(checkmenu);
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        Launcher.mnEdit.setVisible(true);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        int dr;
        FindReplaceDialog findReplaceDialog = this.controller.getFindReplaceDialog();
        if (findReplaceDialog != null) {
            findReplaceDialog.dispose();
            this.controller.setFindReplaceDialog(null);
        }
        if (this.controller.dialogHistory != null) {
            this.controller.dialogHistory.dispose();
        }
        if (this.controller.contractShell != null) {
            this.controller.contractShell.dispose();
        }
        if (this.controller.formGramStruct != null) {
            this.controller.formGramStruct.dispose();
        }
        if (this.controller.alignmentDialog != null) {
            this.controller.alignmentDialog.dispose();
        }
        if (this.controller.presentationDialog != null) {
            this.controller.presentationDialog.dispose();
        }
        if (this.controller.debugShell != null) {
            this.controller.debugShell.dispose();
        }
        if (this.controller.modified && !Launcher.projectMode && (dr = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), "Save grammar file?", "NooJ: grammar file has not been saved", 0, 3, null, null, null)) == 0) {
            this.controller.saveGrammar();
        }
        int n = Launcher.mnWindows.getItemCount();
        String basename = FilenameUtils.getBaseName(this.controller.getFullName()) + "." + FilenameUtils.getExtension(this.controller.getFullName());
        for (int i = 0; i < n; ++i) {
            String aux;
            if (Launcher.mnWindows.getItem(i) == null || !(aux = Launcher.mnWindows.getItem(i).getText()).equals(basename)) continue;
            Launcher.mnWindows.remove(i);
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        this.controller.editor.grammarMenu.setVisible(false);
        this.controller.editor.GrammarEditMenu.setVisible(false);
        Launcher.mnEdit.setVisible(true);
        this.menuBar.repaint();
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }
}

